module.exports = {
  /* SOCKETPORT: WHICH PORT DOES THE WEBSOCKET RUN ON
      DEFAULT: 8000
      RECOMMENDED: 8000 */
	socketPort: 8000,

  /* SOCKETIP: WHICH IP DOES THE WEBSOCKET BIND TO
      DEFAULT: 0.0.0.0
      RECOMMENDED: <THIS SERVER'S PUBLIC IP ADDRESS> */
	socketIP: '0.0.0.0',

  /* SOCKETORIGINS: WHICH DOMAIN IS ALLOWED TO CONNECT TO THIS WEBSOCKET
      DEFAULT: HTTPS://PROXCP.DOMAIN.COM:443
      RECOMMENDED: HTTPS://<PROXCP WEB URL>:443 */
	socketOrigins: 'https://proxcp.domain.com:443',

  /* SQLHOST: MYSQL IP ADDRESS
      DEFAULT: 127.0.0.1
      RECOMMENDED: <SAME MYSQL IP USED IN PROXCP WEB INSTALLATION> */
	sqlHost: '127.0.0.1',

  /* SQLUSER: MYSQL USER
      DEFAULT: ROOT
      RECOMMENDED: <SAME MYSQL USER USED IN PROXCP WEB INSTALLATION> */
	sqlUser: 'root',

  /* SQLPASSWORD: MYSQL PASSWORD
      DEFAULT: PASSWORD
      RECOMMENDED: <SAME MYSQL PASSWORD USED IN PROXCP WEB INSTALLATION> */
	sqlPassword: 'password',

  /* SQLDB: MYSQL DATABASE
      DEFAULT: PROXCP
      RECOMMENDED: <SAME DATABASE NAME USED IN PROXCP WEB INSTALLATION> */
	sqlDB: 'proxcp',

  /* VNCP_SECRET_KEY: SECRET KEY USED FOR DATA ENCRYPTION (DO NOT LOSE THIS OR SHARE IT)
      DEFAULT: EMPTY
      RECOMMENDED: <SAME SECRET KEY GENERATED DURING PROXCP WEB INSTALLATION> */
	vncp_secret_key: '',

  /* TIMEZONE: TIMEZONE USED FOR CRON JOB EXECUTION (LIST: http://php.net/manual/en/timezones.php)
      DEFAULT: AMERICA/NEW_YORK
      RECOMMENDED: <YOUR LOCAL TIMEZONE> */
	timezone: 'America/New_York',

  /* COMPANY_NAME: SELF-EXPLANATORY
      DEFAULT: COMPANY
      RECOMMENDED: <SELF-EXPLANATORY> */
	company_name: 'Company',

  /* CRON_TO_EMAIL: EMAIL ADDRESS WHERE CRON JOB REPORTS ARE SENT TO
      DEFAULT: SUPPORT@DOMAIN.COM
      RECOMMENDED: <ANY EMAIL ADDRESS THAT MAKES SENSE FOR YOU> */
	cron_to_email: 'support@domain.com'
};
